from app import db, login_manager
from flask_login import UserMixin
from datetime import datetime

class User(UserMixin, db.Model):
    __tablename__ = 'users'
    
    id = db.Column(db.Integer, primary_key=True)
    ts_number = db.Column(db.String(20), unique=True, nullable=False)
    first_name = db.Column(db.String(50), nullable=False)
    last_name = db.Column(db.String(50), nullable=False)
    email = db.Column(db.String(100), unique=True, nullable=False)
    phone = db.Column(db.String(20))
    password_hash = db.Column(db.String(255), nullable=False)
    role = db.Column(db.Enum('admin', 'county_boss', 'headteacher', 'teacher'), nullable=False)
    county_id = db.Column(db.Integer, db.ForeignKey('counties.id'))
    school_id = db.Column(db.Integer, db.ForeignKey('schools.id'))
    status = db.Column(db.Enum('active', 'pending', 'suspended'), default='pending')
    created_at = db.Column(db.DateTime, default=datetime.utcnow)
    updated_at = db.Column(db.DateTime, default=datetime.utcnow, onupdate=datetime.utcnow)
    
    # Relationships
    county = db.relationship('County', backref='users')
    school = db.relationship('School', backref='users')
    
    def get_avatar_initials(self):
        return f"{self.first_name[0]}{self.last_name[0]}".upper()

@login_manager.user_loader
def load_user(user_id):
    return User.query.get(int(user_id))

# Add other models from the schema here (County, School, etc.)